int Speed_Voltage_Pin = 6;
int Direction_Pin = 9;
int Puls_Pin = 8;

const int len_Mean_Array = 20;
int Last_10_Speeds[len_Mean_Array];

unsigned long aktuelle_Zeit = 0;

unsigned long next_Puls_time = 0;
unsigned long Puls_deactivation_time = 0;
unsigned long next_Speed_check = 100000;

unsigned long Puls_Delay_in_MicroSec = 0;
unsigned long Activation_duration_in_MicroSec = 5;
unsigned long Time_between_Speed_checks_in_Microsec = 50000;

float Upper_Speed_Lim = 5;       // Rotations / s 
int Pulses_per_Rotation = 3200;

float MeanSpeed = 0;
float Des_Rotations = 0;
unsigned long Puls_Dealy = 0;


int Get_Desired_Speed(){
  int Total_of_array = 0;

  while (Total_of_array < len_Mean_Array*35) {
    Total_of_array = 0;

    for (int a=1; a<len_Mean_Array; a++){        // Shifting values one over
      Last_10_Speeds[a-1] = Last_10_Speeds[a];
      Total_of_array += Last_10_Speeds[a];
    }
    Last_10_Speeds[len_Mean_Array-1] = analogRead(Speed_Voltage_Pin)*1.6; // writing into the last Buffer Value (max selve measured 2.92 V)
    Total_of_array += Last_10_Speeds[len_Mean_Array-1];
  }
  
  MeanSpeed = Total_of_array;
  MeanSpeed /= len_Mean_Array;                   // max of 1023 !
  MeanSpeed /= 1023;                             // max of 1
  Des_Rotations = MeanSpeed * Upper_Speed_Lim;   // max of Upper_Speed_Lim

  Puls_Dealy = 1000000 / (Des_Rotations*Pulses_per_Rotation); // Has to be in microseconds -> 1 min = 60.000.000 microsec
  return Puls_Dealy;
}

void setup() {
  // put your setup code here, to run once:
  pinMode(Speed_Voltage_Pin, INPUT);
  pinMode(Direction_Pin, OUTPUT);
  pinMode(Puls_Pin, OUTPUT);

  // Establishing Serial connection
  Serial.begin(9600);
  delay(2000);
  if (Serial) {Serial.println("Serial communication established!"); }

  //Set Output rotation
  digitalWrite(Direction_Pin, HIGH);
}


void loop() {
  // put your main code here, to run repeatedly:

  aktuelle_Zeit = micros();

  if (next_Puls_time <= aktuelle_Zeit) {
    // Activate Puls
    digitalWrite(Puls_Pin, HIGH);

    // Calculate next_Puls_time
    next_Puls_time = aktuelle_Zeit + Puls_Delay_in_MicroSec;

    // Calculate Puls_deactivation_time
    Puls_deactivation_time = aktuelle_Zeit + Activation_duration_in_MicroSec;
  }

  else if (Puls_deactivation_time <= aktuelle_Zeit) {
    // Deactivate Puls
    digitalWrite(Puls_Pin, LOW);
  }
  

  if (next_Speed_check <= aktuelle_Zeit) {
    Puls_Delay_in_MicroSec = Get_Desired_Speed();

    // Calculate next_Speed_check
    next_Speed_check = aktuelle_Zeit + Time_between_Speed_checks_in_Microsec;
  }
}
